<?php
include("../includes/config.php");
include("../includes/db_connect.php");
include("../includes/upload.class.php");

$result = array();
$ext_allowed =  array('png' ,'jpg','jpeg','JPG','JPEG','PNG');

function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

if(isset($_FILES["photo"]) && isset($_POST["user_id"])) {
	
	if(TEST_MODE) {
		$result["error"] = "You can't update the profile picture in demo mode.";
		$result["status"] = 998;
	} else {
	
		if($_SESSION["RANK"] < 1) {
	
			$result["status"] = 0;
			$result["error"] = "You're not an admin";
			
		} else {
			
			$user_id = $_POST["user_id"];
			$photo = $_FILES["photo"];
			
			$path = $photo['name'];
			$ext = pathinfo($path, PATHINFO_EXTENSION);
			
			if(!empty($photo) && $photo["size"] > 0) {
				
				if($ext == "jpg" || $ext == "png" || $ext == "jpeg") {
					$handle = new Upload($photo);
					$err_img = false;
		
					if ($handle->uploaded) {
						$handle->image_resize         = false;
						$handle->file_name_body_add   = "_" . mt_rand(0,99999);
						$handle->Process('../uploads/profile_pictures');
						
						if ($handle->processed) {
							$err_img = false;
							$handle->clean();
							$has_img = true;
							
							$photo_url = "../uploads/profile_pictures/".$handle->file_dst_name;
							$photo_url_db = "uploads/profile_pictures/".$handle->file_dst_name;
						} else {
							$err_img = true;
						}
				
					} else {
						$err_img = true;
					}
					
					if($err_img) {
						
						$result["error"] = "Please upload a JPG or PNG photo only!";
						$result["status"] = 998;
						
					} else {
						
						// Insert into the DB
						$stmt = $dbh->prepare("UPDATE user SET profile_picture = :photo WHERE id = :user_id");
											
						$stmt->bindParam(':photo', $photo_url_db);
						$stmt->bindParam(':user_id', $user_id);
						$stmt->execute();
						
						$result["status"] = 1;	
						
					}
					
				} else {
					$result["error"] = "Please upload only a JPG or PNG file...";
				}
			}
		
		}
	
	}
		

	
} else {
	$result["status"] = 999;
	$result["error"] = "Please fill the form.";
}


echo json_encode($result);
?>